<?php
defined('PF_VERSION') OR exit('Access denied');
$current = isset($_GET['current']) ? (int)$_GET['current'] : '';
?>
<div class="row pull-right btnTop">
    <div class="col-md-12">
        <?php
        add_toolbar_button(form_button("<i class='fa fa-plus'></i> " . __('New Category', 'post'), array('onclick' => "window.location='" . admin_url('act=create') . "'", 'class' => 'btn btn-primary')));
        ?>
    </div>
</div><!--end button-->

<div class="hidden" id="messageErrorJS">
    <ul>
        <li class="confirmDelete"><?php echo __('Are you sure to delete this category?', 'post'); ?></li>
        <li class="notChecked"><?php echo __('No item are selected', 'post'); ?></li>
        <li class="confirmBulkAction"><?php echo __('Are you sure to perform this action?', 'post'); ?></li>
        <li class="errorSearch"><?php echo __('Please enter the search conditions', 'post'); ?></li>
    </ul>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-list"></i> <?php echo __('Categories', 'post'); ?></h3>
            </div>
            <div class="panel-body">
                <?php require_once ABSPATH . '/includes/common/plugin/views/alert.php'; ?>
                <div class="row margin-bottom-10">
                    <div class="col-sm-7">
                        <ul class="list-unstyled topControl">
                            <li id="bulkAction">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                                        <?php echo __('Select Action ', 'post'); ?> <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li data-action="3"><a href="#"><?php echo __('Delete', 'post'); ?></a></li>
                                        <li data-action="1"><a href="#"><?php echo __('Publish', 'post'); ?></a></li>
                                        <li data-action="0"><a href="#"><?php echo __('Unpublish', 'post'); ?></a></li>
                                    </ul>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-5 miniSearch">
                        <div class="input-group">
                            <input type="text" class="form-control" name="kw" value="<?php echo get_value_search(); ?>" placeholder="<?php echo __('Please enter the search conditions', 'post'); ?>">
                            <span class="input-group-btn">
                                <button class="btn btn-default btn-flat" type="button" id="btnMiniSearch">
                                    <i class="fa fa-search"></i> <?php echo __('Search', 'post'); ?>
                                </button>
                                <a class="btn btn-default btn-flat" href="<?php echo admin_url('admin-page=post&sub_page=category', false); ?>">
                                    <i class="fa fa-times-circle"></i>
                                </a>
                            </span>
                        </div><!-- /input-group -->
                    </div><!--end #search-->
                </div>

                <div class="row margin-bottom-10">
                    <div class="col-md-6">
                        <ul class="list-unstyled filer">
                            <li class="filterByStatus">                        
                                <div class="btn-group">
                                    <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown">
                                        <?php printf(__('%s', 'post'), show_status_filter()); ?> <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="<?php echo admin_url('admin-page=post&sub_page=category', false); ?>"><?php echo __('All', 'post'); ?></a></li>
                                        <li><a href="<?php echo admin_url('admin-page=post&sub_page=category&status=1', false); ?>"><?php echo __('Published', 'post'); ?></a></li>
                                        <li><a href="<?php echo admin_url('admin-page=post&sub_page=category&status=2', false); ?>"><?php echo __('Unpublished', 'post'); ?></a></li>
                                    </ul>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <div class="pull-right">
                            <?php echo $pagination->short_page_link(); ?>
                        </div>
                    </div>
                </div><!--end row-->

                <form method="post" role="form" action="<?php echo admin_url('&act=bulk_action'); ?>">
                    <input type="hidden" value="1" name="action"/>
                    <input type="hidden" value="<?php echo $current ?>" name="current"/>
                    <table class="bootstrap-table" id="listComments">
                        <tr>
                            <th data-fixed="left">
                                <input type="checkbox" id="checkAll"/>
                            </th>
                            <th class="text-left"><?php echo __('Name', 'post'); ?></th>
                            <th style="width: 300px"><?php echo __('Description', 'post'); ?></th>
                            <th style="width: 200px"><?php echo __('Author', 'post'); ?></th>
                            <th style="width: 90px"><?php echo __('Status', 'post'); ?></th>
                            <th data-fixed="right"><?php echo __('Actions', 'post'); ?></th>
                        </tr>
                        <?php
                            if (isset($categories) && is_array($categories)):
                                foreach ($categories as $category):
                                    $type = $category->category_status == 1 ? 2 : 1;
                            
                                    ?> 
                                    <tr>
                                        <td>
                                            <input type="checkbox" name="id[]" class="itemCheckBox" value="<?php echo $category->id; ?>"/>
                                        </td>
                                        <td>
                                            <?php echo e($category->category_name); ?>
                                        </td>
                                        <td>
                                            <?php echo e($category->category_description); ?>
                                        </td>
                                        <td>
                                            <?php echo e($category->user_name); ?>
                                        </td>
                                        <td>
                                            <?php echo show_status(admin_url("admin-page=post&sub_page=category&act=status&id={$category->id}&type=$type&current={$current}", false), $category->category_status); ?>
                                        </td>
                                        <td>
                                            <a class="btn btn-info btn-xs" href="<?php echo admin_url("admin-page=post&sub_page=category&act=edit&id={$category->id}$current_param", false); ?>" title="<?php echo __('Edit Category', 'post'); ?>"><i class="fa fa-edit"></i></a>
                                            <a class="btn btn-danger btn-xs confirmationDelete" href="<?php echo admin_url("admin-page=post&sub_page=category&act=delete&id={$category->id}", false); ?>" title="<?php echo __('Delete Category', 'post'); ?>"><i class="fa fa-trash-o"></i></a>
                                        </td>
                                    </tr>
                                <?php
                            endforeach;
                        endif;
                        ?>
                    </table>
                </form>
            </div><!---end .panel-body-->
            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-6">
                        <?php echo $pagination->page_lable(); ?>
                    </div>
                    <div class="col-md-6">
                        <div class="pull-right">
                            <?php echo $pagination->page_links($url . '&'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>